/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Web Client
 * Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc.
 *
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at: https://www.zimbra.com/license
 * The License is based on the Mozilla Public License Version 1.1 but Sections 14 and 15
 * have been added to cover use of software over a computer network and provide for limited attribution
 * for the Original Developer. In addition, Exhibit A has been modified to be consistent with Exhibit B.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is Zimbra Open Source Web Client.
 * The Initial Developer of the Original Code is Zimbra, Inc.  All rights to the Original Code were
 * transferred by Zimbra, Inc. to Synacor, Inc. on September 14, 2015.
 *
 * All portions of the code are Copyright (C) 2005, 2006, 2007, 2009, 2010, 2011, 2013, 2014, 2016 Synacor, Inc. All Rights Reserved.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @constructor
 * @class
 * DwtDragEvent is generated by the Drag and Drop framework when a drag operation is
 * in process. The drag event is dispatched to the registered {@link DwtDragSource} instance.
 * 
 * @author Ross Dargahi
 * 
 * @see DwtDragSource
 */
DwtDragEvent = function() {
	/**
	 * Type of drag operation. One of:
	 * <ul>
	 * <li>{@link DwtDragEvent.DRAG_START}</li>
	 * <li>{@link DwtDragEvent.SET_DATA}</li>
	 * <li>{@link DwtDragEvent.DRAG_END}</li>
	 * </ul>
	 */
	this.operation = null;
	
	/**
	 * Drag source control
	 * @type DwtControl
	 */
	this.srcControl = null;
	
	/**
	 * Action being performed. One of:
	 * <ul>
	 * <li>{@link Dwt.DND_DROP_NONE}</li>
	 * <li>{@link Dwt.DND_DROP_COPY}</li>
	 * <li>{@link Dwt.DND_DROP_MOVE}</li>
	 * </ul>
	 */
	this.action = null;
	
	/**
	 * Whether the DnD framework should perform the operation. The application is
	 * responsible for setting this value based on whatever business logic it is
	 * implementing
	 * @type boolean
	 */
	this.doIt = false;
	
	/**
	 * Drag source data. This is the application data associated with the item being dragged.
	 */
	this.srcData = null;
};

/**
 * Drag initialization.
 */
DwtDragEvent.DRAG_INIT = "INIT";

/**
 * Drag is starting.
 */
DwtDragEvent.DRAG_START = "START";

/**
 * Set the <code>srcData</code> field of the event.
 */
DwtDragEvent.SET_DATA = "SET_DATA";

/**
 * Drag movement has occurred.
 */
DwtDragEvent.DRAG_MOVE = "MOVE";

/**
 * Drag has ended.
 */
DwtDragEvent.DRAG_END = "END";

/**
 * Drag canceled (i.e. dropped on invalid target).
 */
DwtDragEvent.DRAG_CANCEL = "CANCEL";
